// Funcion que exportara el listado a excel
async function exportarExcel() {
    showLoadingAlert("Generando reporte...")
    const result = await fetch(
        `${BASE_URL}clientes/admin-giros?` + new URLSearchParams({
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte giros.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    showLoadingAlert("Generando reporte...")
    const result = await fetch(
        `${BASE_URL}clientes/admin-giros?` + new URLSearchParams({
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte giros.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
