// admin-sucursales.js

CLIENTES = `${BASE_URL}clientes`

$(document).ready(function () {
    // Evento cuando se agrega una nueva sucursal
    $("#admin-sucursales-form").submit(function () {
        showLoadingAlert("Agregando sucursal...")
    })
})

// Funcion que mostrara una alerta para que el usuario pueda cambiar el nombre de alguna sucursal
async function cambiarNombreSucursal(sucursalId, nombreActual) {
    let inputValue = nombreActual
    // Muestra la alerta
    const { value: nuevoNombre } = await Swal.fire({
        title: "Ingrese un nuevo nombre",
        input: "text",
        inputLabel: "",
        inputValue,
        showCancelButton: true,
        cancelButtonText: "Cancelar",
        inputValidator: (value) => {
            if (!value) {
                return "¡Necesitas escribir algo!";
            }
        }
    });
    if (nuevoNombre) {
        showLoadingAlert("Modificando nombre...")

        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        $.ajax({
            type: "POST",
            url: `${CLIENTES}/admin-sucursales/${idCliente}`,
            headers: {
                "X-CSRFToken": csrftoken
            },
            data: {
                editar: true,
                nuevo_nombre: nuevoNombre,
                sucursal_id: sucursalId
            },
            success: function (data) {
                showSuccessConfirmAlert("Se modifico el nombre de la sucursal exitosamente", location.href)
            },
            error: function (a, b, c) {
                console.log(a, " ", b, " ", c)
            }
        })
    }
}

// Funcion que exportara a excel el listado de puestos
async function exportarExcel() {
    showLoadingAlert("Exportando a Excel...")

    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    let url = `${CLIENTES}/admin-sucursales/${idCliente}`
    let headers = new Headers()
    headers.append("X-CSRFToken", csrftoken)
    headers.append("x-requested-with", "XMLHttpRequest")
    //headers.append("Content-Type", "application/json")

    /*
    let body = {
        exportar_excel: true
    }
    */
    let body = new URLSearchParams()
    body.append("exportar_excel", true)

    const result = await fetch(url, {
        method: "POST",
        headers: headers,
        //body: JSON.stringify(body)
        body: body
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara a PDF el listado de puestos
async function exportarPdf() {
    showLoadingAlert("Exportando a PDF...")

    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    let url = `${CLIENTES}/admin-sucursales/${idCliente}`
    let headers = new Headers()
    headers.append("X-CSRFToken", csrftoken)
    headers.append("x-requested-with", "XMLHttpRequest")
    //headers.append("Content-Type", "application/json")

    /*
    let body = {
        exportar_excel: true
    }
    */
    let body = new URLSearchParams()
    body.append("exportar_pdf", true)

    const result = await fetch(url, {
        method: "POST",
        headers: headers,
        body: body
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}