// agregar-empresa.js

API = `${BASE_URL}api`
EMPRESAS = `${BASE_URL}empresas`

// Indice de cuentas bancarias
let indiceCuentaBancaria = 0;
// Lista de indices de las cuentas bancarias guardadas actualmente
let cuentasBancariasGuardadasIndice = [];

// Indice de la cuenta bancaria que se esta modificando
let indiceCuentaBancariaModificacion = undefined;

$(document).ready(function () {
    // ----- Multiselect OFICINAS AL AGREGAR CUENTA BANCARIA DE EMPRESA -------
    let oficinaCBSelectBtn = document.getElementById("oficina-c-b-select-btn")
    //const selectBtn = document.querySelector(".select-btn");
    //const oficinaCBItems = document.querySelectorAll(".item");
    let oficinaCBItems = document.querySelectorAll(".oficina-c-b-item")

    // Item default de el multiselect de oficinas
    const DEFAULT_OFICINAS_ITEM = "Todas las oficinas"

    oficinaCBSelectBtn.addEventListener("click", () => {
        //alert("click")
        oficinaCBSelectBtn.classList.toggle("open")
    })

    oficinaCBItems.forEach(item => {
        item.addEventListener("click", () => {
            item.classList.toggle("checked")

            //let checked = document.querySelectorAll(".checked"),
            //let checked = document.querySelectorAll('li[class="checked"][class="oficina-item"]')
            let checked = document.querySelectorAll(".checked.oficina-c-b-item")
            btnText = document.querySelector(".oficina-c-b-btn-text")


            if (checked && checked.length > 0) {
                btnText.innerText = `${checked.length} seleccionadas`
            } else {
                btnText.innerText = `Selecciona oficinas`
            }

            // Obtiene el texto de el primer elemento de la lista
            let itemText = item.getElementsByClassName("item-text")[0].textContent

            // Si selecciona el item (Todas las oficinas) marcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && item.classList.contains("checked") && checked.length >= 1) {
                oficinaCBItems.forEach(item => {
                    /*
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                        */
                    item.classList.add("checked")
                    btnText.innerText = DEFAULT_OFICINAS_ITEM
                })
            }

            // Si el usuario desmarca la opcion 'Todas las oficinas' desmarcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                oficinaCBItems.forEach(item => {
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                })
                // Establece texto en boton
                btnText.innerText = `Selecciona oficinas`
            }

            // Si el usuario desmarca alguna otra opcion que no sea 'Todas las oficinas' desmarcara la opcion de 'Todas las oficinas'
            // (Si esta marcada)
            if (itemText != DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                let defaultOficinaItem = oficinaCBItems[0] // 'Todas las oficinas'
                defaultOficinaItem.classList.remove("checked")

                // Despues de remover la opcion de 'Todas las oficinas',
                // Muestra el numero de opciones seleccionadas (Solo si hay almenos una)
                if (checked && checked.length > 0) {
                    checked = document.querySelectorAll(".checked.oficina-c-b-item")
                    btnText.innerText = `${checked.length} seleccionadas`
                }
            }

            // Si selecciona la primera opción(Todas las oficinas) y solo hay una opcion
            // seleccionada, mostrara otro texto de el boton
            if (checked && checked.length == 1 && itemText == DEFAULT_OFICINAS_ITEM) {
                btnText.innerText = DEFAULT_OFICINAS_ITEM
            }
        })
    })


    // Contenedor del listado de cuentas bancarias
    let cuentasBancariasContainer = document.getElementById("cuentas-b-container")


    // -------- Recuperación de valores -------

    // **** Estatus *****
    $("#estatus").val(estatus).change()

    if (estatus == "Baja") {
        // Establece el texto de baja
        $("#motivo-baja").val(motivoBaja)
        // Establece la fecha de baja
        $("#fecha-baja").val(fechaBaja)
        // Muestra el texto y fecha de baja
        $("#baja-container").css('display', "")
        // Establece el texto y fecha de baja como requerido
        $("#motivo-baja").prop('required', true)
        $("#fecha-baja").prop('required', true)
    }

    if (estatus == "Lista negra") {
        // Establece el texto de baja
        $("#motivo-lista-negra").val(motivoListaNegra)
        // Establece la fecha de baja
        $("#fecha-lista-negra").val(fechaListaNegra)
        // Muestra el texto y fecha de baja
        $("#lista-negra-container").css('display', "")
        // Establece el texto y fecha de baja como requerido
        $("#motivo-lista-negra").prop('required', true)
        $("#fecha-lista-negra").prop('required', true)
    }

    // Formulario
    let editarEmpresaForm = document.getElementById("editar-empresa-form")

    // --------- Subida de formulario principal -----------
    $("#editar-empresa-form").submit(function (evt) {
        // Muestra alerta de carga
        showLoadingAlert("Modificando empresa...")

        // --- Verifica que haya validado un código postal personal ---
        let municipio = $("#municipio-ciudad").val() || ""

        if (municipio == "") {
            evt.preventDefault()
            Swal.close()
            // Si no valido el codigo postal, mostrara una alerta de error
            showFailAlert("¡Atención!", "Debe validar el código postal comercial y seleccionar una colonia.")
            return;
        }

        // Cuando el formulario se suba, verificara que haya seleccionado por lo menos una oficina, de no ser asi
        // mostrara una alerta
        let itemsContainer = document.getElementById("oficina-select-list-items")
        let itemsCount = itemsContainer.querySelectorAll(".item.checked").length
        console.log("count" + itemsCount)
        if (itemsCount <= 0) {
            evt.preventDefault()
            Swal.close()
            showFailAlert("Aviso", "Debe seleccionar por lo menos una oficina.")
            return;
        }

        // Aqui obtiene las opciones seleccionadas del filtro de 'Oficinas'
        let oficinaListItems = document.getElementById("oficina-select-list-items")
        oficinaListItems = oficinaListItems.querySelectorAll("li")
        oficinaListItems.forEach(item => {
            // Si el item esta seleccionado
            if (item.classList.contains("checked")) {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Crea un input hidden para enviarlo para la busqueda
                let inputHidden = document.createElement("input")
                inputHidden.type = "hidden"
                inputHidden.value = textContent
                inputHidden.name = "oficinas-items[]"
                // Agrega el input al formulario de registro de puesto
                editarEmpresaForm.appendChild(inputHidden)

            }
        })

        // ---- Creara un input hidden que contendra el numero de cuentas bancarias que se crearon para esta empresa ----
        let numCBInput = document.createElement("input");
        numCBInput.type = "hidden";
        numCBInput.name = "num-cuentas-bancarias";
        numCBInput.value = indiceCuentaBancaria // Le da como valor el indice actual de cuenta bancaria
        editarEmpresaForm.appendChild(numCBInput);

    })


    // ---------------- Validacion código postal personal --------------

    // Evento de boton para validacion
    $("#validar-codigo-postal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa").val(response["estado"])
                // Municipio
                $("#municipio-ciudad").val(response["municipio"])

                // Colonias
                $("#colonia-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-select").css('display', '')
                $("#colonia-select").removeAttr('disabled')
                $("#colonia-select").removeAttr('readonly')
                // Oculta input text de colonia
                $("#colonia-input").css('display', 'none')
                $("#colonia-input").removeAttr("readonly")
                $("#colonia-input").attr('disabled', true)

                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-error").text("")
        // Muestra select de colonia
        $("#colonia-select").empty()
        $("#colonia-select").attr("readonly", true)
        $("#colonia-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-input").css('display', 'none')
        $("#colonia-input").removeAttr("readonly")
        $("#colonia-input").attr('disabled', true)

        $("#municipio-ciudad").val("")
        $("#entidad-federativa").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')

        // Cuando cambie el codigo postal del domicilio comercial, desactivara el boton de copiar
        $("#copiar-domicilio-fiscal").prop('disabled', true)
    })

    // ------ Validacion código postal fiscal -----

    // Evento de boton para validacion
    $("#validar-codigo-postal-fiscal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal-fiscal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal-fiscal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa-fiscal").val(response["estado"])
                // Municipio
                $("#municipio-ciudad-fiscal").val(response["municipio"])

                // Colonias
                $("#colonia-fiscal-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-fiscal-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-fiscal-select").css('display', '')
                $("#colonia-fiscal-select").removeAttr('disabled')
                $("#colonia-fiscal-select").removeAttr("readonly")
                // Oculta input text de colonia
                $("#colonia-fiscal-input").css('display', 'none')
                $("#colonia-fiscal-input").removeAttr("readonly")
                $("#colonia-fiscal-input").attr('disabled', true)


                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-fiscal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal-fiscal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-fiscal-error").text("")
        // Muestra select de colonia
        $("#colonia-fiscal-select").empty()
        $("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-fiscal-input").css('display', 'none')
        $("#colonia-fiscal-input").removeAttr("readonly")
        $("#colonia-fiscal-input").attr('disabled', true)

        $("#municipio-ciudad-fiscal").val("")
        $("#entidad-federativa-fiscal").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal-fiscal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')
    })

    // --- Evento de seleccion de colonia de domicilio comercial -----
    $("#colonia-select").on('change', function (evt) {
        // Cuando se selecciona una colonia, habilitara el botón de 'Copiar a domicilio fiscal'
        let value = evt.target.value
        let disabled = value == null || value == '' || value == undefined || value == ""
        $("#copiar-a-domicilio-fiscal").prop('disabled', disabled)
    })

    // ----- Evento de copiar domicilio comercial al domicilio fiscal------
    $("#copiar-a-domicilio-fiscal").on('click', function () {
        // Obtiene los valores del domicilio comercial
        let calleNumero = $("#calle-numero").val()
        let codigoPostal = $("#codigo-postal").val()

        let colonia = $('#colonia-select').val() || null
        if (colonia == null)
            colonia = $("#colonia-input").val()


        let municipio = $("#municipio-ciudad").val()
        let entidadFederativa = $("#entidad-federativa").val()
        // Datos para razon social de persona fisica
        let primerNombre = $("#primer-nombre").val() || ""
        let segundoNombre = $("#segundo-nombre").val() || ""
        let apellidoPaterno = $("#apellido-paterno").val() || ""
        let apellidoMaterno = $("#apellido-materno").val() || ""

        let razonSocialFiscal = `${primerNombre} ${segundoNombre} ${apellidoPaterno} ${apellidoMaterno}`

        // Copia la razon social fiscal para una persona fisica
        $("#razon-social-fiscal").val(razonSocialFiscal)

        // Oculta select de colonia
        $("#colonia-fiscal-select").empty()
        //$("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").attr("disabled", true)
        $("#colonia-fiscal-select").css('display', 'none')
        // Muestra input text de colonia
        $("#colonia-fiscal-input").css('display', '')
        $("#colonia-fiscal-input").attr("readonly", true)

        // Copia los valores del domicilio comercial al domicilio fiscal
        $("#calle-numero-fiscal").val(calleNumero)
        $("#codigo-postal-fiscal").val(codigoPostal)
        $("#colonia-fiscal-input").val(colonia)
        $("#municipio-ciudad-fiscal").val(municipio)
        $("#entidad-federativa-fiscal").val(entidadFederativa)



        // Desactiva el boton de 'Validar codigo postal fiscal'
        $("#validar-codigo-postal-fiscal").attr('disabled', true)

        showToast("Se copió el domicilio correctamente.", "success")
    })

    // ---- Evento de copiar datos acta constituiva a datos de poder de representante legal
    $("#copiar-poder-r-legal").on('click', function () {
        // Obtiene los valores del acta constitutiva
        let aNumEscritura = $("#acta-constitutiva-num-escritura").val()
        let aFecha = $("#acta-constitutiva-fecha").val()
        let aNombreNotario = $("#acta-constitutiva-nombre-notario").val()
        let aLibro = $("#acta-constitutiva-libro").val()
        let aFolio = $("#acta-constitutiva-folio").val()
        let aNumNotaria = $("#acta-constitutiva-num-notaria").val()
        let aMunicipio = $("#acta-constitutiva-municipio").val()
        let aEstado = $("#acta-constitutiva-estado").val()

        // Copia los valores a poder del representante legal
        $("#poder-representante-legal-num-escritura").val(aNumEscritura)
        $("#poder-representante-legal-fecha").val(aFecha)
        $("#poder-representante-legal-nombre-notario").val(aNombreNotario)
        $("#poder-representante-legal-libro").val(aLibro)
        $("#poder-representante-legal-folio").val(aFolio)
        $("#poder-representante-legal-num-notaria").val(aNumNotaria)
        $("#poder-representante-legal-municipio").val(aMunicipio)
        $("#poder-representante-legal-estado").val(aEstado)

        showToast("Se copiaron los datos de acta constitutiva correctamente.", "success")
    })

    // ---- Evento de agregar cuenta bancaria para la empresa ---
    $("#agregar-cuenta-bancaria-btn").on('click', function () {

        // Obtiene los campos de texto de la persona responsable de la cuenta bancaria
        let nombreResponsable = document.getElementById("nombre-persona-responsable-c-b")

        // Obtiene los input del formulario
        let clabeInterbancaria = document.getElementById("clabe-interbancaria")
        let numCuentaBancaria = document.getElementById("num-cuenta-bancaria")
        let numTarjetaBancaria = document.getElementById("num-tarjeta-bancaria")
        let banco = document.getElementById("banco")
        let alias = document.getElementById("alias")
        let personaResponsable = document.getElementById("persona-responsable")

        // Verifica que haya completado todos los campos
        if (clabeInterbancaria.value == "" || numCuentaBancaria.value == "" ||
            numTarjetaBancaria.value == "" || banco.value == "" || alias.value == "" || personaResponsable.value == ""
        ) {
            showFailAlert("¡Atención!", "Debe completar todos los campos de la cuenta bancaria");
            return;
        }

        // Verifica que haya seleccionado por lo menos una oficina
        let oficinasChecked = document.querySelectorAll(".checked.oficina-c-b-item").length

        if (oficinasChecked == 0) {
            showFailAlert("¡Atencion!", "Debe seleccionar por lo menos una oficina para agregar la cuenta bancaria.")
            return;
        }

        // Mostrara el contenedor de cuentas bancarias
        $("#cuentas-b-container").css('display', '')
        // Mostrara el contenedor de responsables de cuenta bancaria
        $("#responsables-c-b-container").css('display', '')

        // Obtiene el posible indice de la cuenta bancaria que se va a modificar
        let indiceCBModificarInput = document.getElementById("modificar-c-b-indice")
        let indiceCBModificar = -1;

        if (indiceCBModificarInput != null) {
            indiceCBModificar = Number(indiceCBModificarInput.value);
        }

        // ----------- Si el cuenta bancaria se va a guardar por primera vez, ejecutara el siguiente bloque de codigo ---
        if (!cuentasBancariasGuardadasIndice.includes(indiceCBModificar)) {
            // **** Crea inputs hidden con los datos del cuenta bancaria ingresado para agregarlos al formulario ****


            // --- Input que guardara el indice de la cuenta bancaria ---
            let indiceCBIH = document.createElement("input")
            indiceCBIH.value = indiceCuentaBancaria

            // Variable que guarda localmente el indice de la cuenta bancaria
            let indiceCBTemp = indiceCuentaBancaria;

            // ---- Clabe interbancaria ----
            let clabeInterbancariaInputHidden = document.createElement("input");
            clabeInterbancariaInputHidden.type = "hidden";
            clabeInterbancariaInputHidden.name = "clabe-interbancaria-" + indiceCuentaBancaria;
            clabeInterbancariaInputHidden.value = clabeInterbancaria.value;
            clabeInterbancariaInputHidden.id = "clabe-interbancaria-" + indiceCuentaBancaria;

            // ---- Numero de cuenta bancaria ----
            let numCuentaBancariaInputHidden = document.createElement("input");
            numCuentaBancariaInputHidden.type = "hidden";
            numCuentaBancariaInputHidden.name = "num-cuenta-bancaria-" + indiceCuentaBancaria;
            numCuentaBancariaInputHidden.value = numCuentaBancaria.value;
            numCuentaBancariaInputHidden.id = "num-cuenta-bancaria-" + indiceCuentaBancaria;

            // ---- Numero de tarjeta bancaria ----
            let numTarjetaBancariaInputHidden = document.createElement("input");
            numTarjetaBancariaInputHidden.type = "hidden";
            numTarjetaBancariaInputHidden.name = "num-tarjeta-bancaria-" + indiceCuentaBancaria;
            numTarjetaBancariaInputHidden.value = numTarjetaBancaria.value;
            numTarjetaBancariaInputHidden.id = "num-tarjeta-bancaria-" + indiceCuentaBancaria;

            // ---- Banco ----
            let bancoInputHidden = document.createElement("input");
            bancoInputHidden.type = "hidden";
            bancoInputHidden.name = "banco-" + indiceCuentaBancaria;
            bancoInputHidden.value = banco.value;
            bancoInputHidden.id = "banco-" + indiceCuentaBancaria;

            // ---- Alias ----
            let aliasInputHidden = document.createElement("input");
            aliasInputHidden.type = "hidden";
            aliasInputHidden.name = "alias-" + indiceCuentaBancaria;
            aliasInputHidden.value = alias.value;
            aliasInputHidden.id = "alias-" + indiceCuentaBancaria;

            // --- Persona responsable ---
            let personaResponsableHidden = document.createElement("input");
            personaResponsableHidden.type = "hidden";
            personaResponsableHidden.name = "persona-responsable-" + indiceCuentaBancaria;
            personaResponsableHidden.value = personaResponsable.value;
            personaResponsableHidden.id = "persona-responsable-" + indiceCuentaBancaria;

            // Agrega los inputs al formulario
            editarEmpresaForm.appendChild(clabeInterbancariaInputHidden);
            editarEmpresaForm.appendChild(numCuentaBancariaInputHidden);
            editarEmpresaForm.appendChild(numTarjetaBancariaInputHidden);
            editarEmpresaForm.appendChild(bancoInputHidden);
            editarEmpresaForm.appendChild(aliasInputHidden);
            editarEmpresaForm.appendChild(personaResponsableHidden);

            // Borra los datos de la tarjeta del formulario
            clabeInterbancaria.value = "";
            numCuentaBancaria.value = "";
            numTarjetaBancaria.value = "";
            banco.value = "";
            alias.value = "";
            personaResponsable.value = "";

            // Muestra en el listado de cuenta bancarias, el nombre del cuenta bancaria agregado recientemente

            // --- Crea el contenedor del elemento ---
            let containerElement = document.createElement("div");
            containerElement.setAttribute("data-index", indiceCuentaBancaria); // establece el indice del cuenta bancaria guardado
            containerElement.classList.add("list-item-container");
            containerElement.style.cursor = "pointer";

            // --- Crea el elemento de texto ----
            let textElement = document.createElement("p");
            textElement.id = "c-b-nombre-elemento-" + indiceCuentaBancaria;
            textElement.classList.add("list-item-text");
            textElement.textContent = aliasInputHidden.value;

            // --- Crea icono ---
            let iconElement = document.createElement("i")
            iconElement.classList.add("nav-icon")
            iconElement.classList.add('material-icons')
            iconElement.classList.add("list-item-icon");
            iconElement.appendChild(document.createTextNode("close"))
            iconElement.onclick = function () {
                // Elimina los input hidden
                editarEmpresaForm.removeChild(clabeInterbancariaInputHidden);
                editarEmpresaForm.removeChild(numCuentaBancariaInputHidden);
                editarEmpresaForm.removeChild(numTarjetaBancariaInputHidden);
                editarEmpresaForm.removeChild(bancoInputHidden);
                editarEmpresaForm.removeChild(aliasInputHidden)
                editarEmpresaForm.removeChild(personaResponsableHidden);

                // Obtiene los input hidden de las oficinas de la cuenta bancaria y los elimina
                let oficinasCB = document.querySelectorAll(`[data-indice-cuenta-bancaria="${indiceCBTemp}"]`)
                oficinasCB.forEach((item) => {
                    editarEmpresaForm.removeChild(item)
                })

                // Verifica si actualmente se esta modificando la cuenta bancaria que se va a eliminar,
                // de ser asi, borrarra los datos del formulario
                if (indiceCBTemp == indiceCuentaBancariaModificacion) {
                    // Borra los valores que se muestran en la UI
                    clabeInterbancaria.value = "";
                    numCuentaBancaria.value = "";
                    numTarjetaBancaria.value = "";
                    banco.value = "";
                    alias.value = "";
                    personaResponsable.value = "";

                    // Cambia texto del boton
                    $("#agregar-cuenta-bancaria-btn").text("+ Agregar otra cuenta bancaria");

                    // Reinicia el valor del indice de la cuenta bancaria actual
                    indiceCuentaBancariaModificacion = undefined;

                    // Elimina el input que contiene el indice de la cuenta bancaria que se va a modificar(Si es que existe)
                    let modificarCBIndiceInput = document.getElementById("modificar-c-b-indice")
                    if (modificarCBIndiceInput != null) {
                        editarEmpresaForm.removeChild(modificarCBIndiceInput)
                    }

                    // Desactiva los checkbox de las oficinas visualmente
                    deschecarOficinas();
                }


                // Elimina la cuenta bancaria de la lista visual (UI)
                cuentasBancariasContainer.removeChild(containerElement);

                // Si ya no hay mas cuentas bancarias, ocultara el texto del contenedor
                if (cuentasBancariasContainer.childElementCount == 1) // Si solo contiene la etiqueta <label>
                    cuentasBancariasContainer.style.display = "none";
            }


            // --- Agrega el elemento de texto al contenedor ---
            containerElement.appendChild(textElement);

            // --- Agrega elemento de icono --
            containerElement.appendChild(iconElement);

            // Agrega evento de click al contenedor del elemento
            containerElement.addEventListener("click", (evt) => {
                onCuentaBancariaClick(evt)
            }); // Fin de evento de click de cuenta bancaria


            // Agrega el contenedor del cuenta bancaria al contenedor principal de los cuenta bancarias
            cuentasBancariasContainer.appendChild(containerElement);

            // Agrega el indice del cuenta bancaria guardado a la lista de cuenta bancarias guardados
            cuentasBancariasGuardadasIndice.push(indiceCuentaBancaria);

            // **** Guarda las oficinas seleccionadas en input hidden ****
            // --- Obtiene las oficinas seleccionadas ---
            let oficinaListItems = document.querySelectorAll(".checked.oficina-c-b-item")

            oficinaListItems.forEach(item => {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Agrega la oficina a un input hidden

                let oficinaInputHidden = document.createElement("input");
                oficinaInputHidden.type = "hidden";
                oficinaInputHidden.name = "oficinas-cuenta-bancaria-" + indiceCuentaBancaria + "[]";
                oficinaInputHidden.value = textContent;
                oficinaInputHidden.id = "oficina-cuenta-bancaria-" + indiceCuentaBancaria;
                oficinaInputHidden.setAttribute("data-indice-cuenta-bancaria", indiceCuentaBancaria)

                editarEmpresaForm.appendChild(oficinaInputHidden)
            })

            // --- Deschekea todas las oficinas seleccionadas para esta cuenta bancaria ---
            deschecarOficinas();

            // Aumenta en UNO el indice actual de cuenta bancarias
            indiceCuentaBancaria += 1;

        }

        // Si el cuenta bancaria ya esta guardado, solamente actualizara los datos correspondientes
        if (cuentasBancariasGuardadasIndice.includes(indiceCBModificar)) {

            // Modifica los valores del formulario
            $("#clabe-interbancaria-" + indiceCBModificar).val(clabeInterbancaria.value);
            $("#num-cuenta-bancaria-" + indiceCBModificar).val(numCuentaBancaria.value);
            $("#num-tarjeta-bancaria-" + indiceCBModificar).val(numTarjetaBancaria.value);
            $("#banco-" + indiceCBModificar).val(banco.value);
            $("#alias-" + indiceCBModificar).val(alias.value);
            $("#persona-responsable-" + indiceCBModificar).val(personaResponsable.value);

            // Modifica el alias de la cuenta bancaria de la lista
            document.getElementById("c-b-nombre-elemento-" + indiceCBModificar).textContent = alias.value;

            // Despues de modificar, modifica el texto del boton de accion de los cuenta bancaria
            $("#agregar-cuenta-bancaria-btn").text("+ Agregar otra cuenta bancaria")

            // Borrara los valores del formulario
            clabeInterbancaria.value = "";
            numCuentaBancaria.value = "";
            numTarjetaBancaria.value = "";
            banco.value = "";
            alias.value = ""
            personaResponsable.value = ""

            // Elimina el input que contiene el indice de la cuenta bancaria que se va a modificar
            editarEmpresaForm.removeChild(document.getElementById("modificar-c-b-indice"))

            // **** Guarda las oficinas seleccionadas en input hidden ****

            // --- Elimina las oficinas seleccionadas actuales de la cuenta bancaria que se esta modificando ---
            let oficinasCuentaBancaria = document.querySelectorAll(`[data-indice-cuenta-bancaria="${indiceCBModificar}"]`)
            oficinasCuentaBancaria.forEach((item) => {
                editarEmpresaForm.removeChild(item);
            })

            // --- Obtiene las oficinas seleccionadas ---
            let oficinaListItems = document.querySelectorAll(".checked.oficina-c-b-item")

            oficinaListItems.forEach(item => {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Agrega la oficina a un input hidden

                let oficinaInputHidden = document.createElement("input");
                oficinaInputHidden.type = "hidden";
                oficinaInputHidden.name = "oficinas-cuenta-bancaria-" + indiceCBModificar + "[]";
                oficinaInputHidden.value = textContent;
                oficinaInputHidden.id = "oficina-cuenta-bancaria-" + indiceCBModificar;
                oficinaInputHidden.setAttribute("data-indice-cuenta-bancaria", indiceCBModificar)

                editarEmpresaForm.appendChild(oficinaInputHidden)
            })

            // --- Deschekea todas las oficinas seleccionadas para esta cuenta bancaria ---
            deschecarOficinas();
        }

    })
})


// ---- Funciones -----

// Funcion que se invocara cuando se haga click en alguna cuenta bancaria de la lista
function onCuentaBancariaClick(evt) {
    // Formulario
    let editarEmpresaForm = document.getElementById("editar-empresa-form")

    // Obtiene los input del formulario
    let clabeInterbancaria = document.getElementById("clabe-interbancaria")
    let numCuentaBancaria = document.getElementById("num-cuenta-bancaria")
    let numTarjetaBancaria = document.getElementById("num-tarjeta-bancaria")
    let banco = document.getElementById("banco")
    let alias = document.getElementById("alias")
    let personaResponsable = document.getElementById("persona-responsable")

    // Muestra en el formulario los valores del cuenta bancaria especifico guardado
    let indiceCuentaBancaria = evt.currentTarget.getAttribute("data-index"); // obtiene el indice del cuenta bancaria guardado

    // Guarda el indice de la cuenta bancaria que se esta modificando
    indiceCuentaBancariaModificacion = indiceCuentaBancaria;

    // Obtiene los valores del cuenta bancaria guardado
    let clabeInterbancariaTemp = document.getElementById("clabe-interbancaria-" + indiceCuentaBancaria).value;
    let numCuentaBancariaTemp = document.getElementById("num-cuenta-bancaria-" + indiceCuentaBancaria).value;
    let numTarjetaBancariaTemp = document.getElementById("num-tarjeta-bancaria-" + indiceCuentaBancaria).value;
    let bancoTemp = document.getElementById("banco-" + indiceCuentaBancaria).value;
    let aliasTemp = document.getElementById("alias-" + indiceCuentaBancaria).value;
    let personaResponsableTemp = document.getElementById("persona-responsable-" + indiceCuentaBancaria).value


    // Establece los datos del cuenta bancaria seleccionado
    clabeInterbancaria.value = clabeInterbancariaTemp;
    numCuentaBancaria.value = numCuentaBancariaTemp;
    numTarjetaBancaria.value = numTarjetaBancariaTemp;
    banco.value = bancoTemp;
    alias.value = aliasTemp;
    personaResponsable.value = personaResponsableTemp;

    // Modifica el texto del boton de accion de los cuenta bancarias
    $("#agregar-cuenta-bancaria-btn").text("Modificar cuenta bancaria")

    // Elimina los posibles inputs anteriores que pudo haber creado al modificar una cuenta bancaria
    document.querySelectorAll("#modificar-c-b-indice").forEach((item) => {
        editarEmpresaForm.removeChild(item);
    })

    // Crea input que contendra como valor el indice del cuenta bancaria a modificar
    let modificarInput = document.createElement("input");
    modificarInput.type = "hidden";
    modificarInput.id = "modificar-c-b-indice";
    modificarInput.value = indiceCuentaBancaria;
    editarEmpresaForm.appendChild(modificarInput);

    // --- Deschekea todas las oficinas seleccionadas actualmente ---
    deschecarOficinas();

    // --- Obtiene las oficinas de la cuenta bancaria seleccionada ---
    let oficinasCuentaBancaria = document.querySelectorAll(`[data-indice-cuenta-bancaria="${indiceCuentaBancaria}"]`)

    // --- Checkea las oficinas correspondientes ---
    // Obtiene todos los items <li> de el filtro de oficina
    let oficinaItems = document.querySelectorAll(".oficina-c-b-item")

    // Itera sobre cada item visual y verifica si conincide con alguna opcion seleccionada de los filtros de busqueda
    // de ser asi, marcara el item visual como seleccionado (Simulando un click)
    oficinaItems.forEach(item => {
        let text = item.getElementsByClassName("item-text")[0].textContent
        oficinasCuentaBancaria.forEach((oficinaCuentaBancaria) => {
            if (text == oficinaCuentaBancaria.value) {
                if (text != "Todas las oficinas") {
                    item.click()
                }
            }
        })
    })
}


// ** Funcion que recuperara las cuentas bancarias de una empresa **
function recuperarCuentasBancarias(listaCuentas) {
    // Contenedor del listado de contactos
    let cuentasBancariasContainer = document.getElementById("cuentas-b-container")

    // Formulario principal
    let editarEmpresaForm = document.getElementById("editar-empresa-form")

    // Obtiene los input del formulario
    let clabeInterbancaria = document.getElementById("clabe-interbancaria")
    let numCuentaBancaria = document.getElementById("num-cuenta-bancaria")
    let numTarjetaBancaria = document.getElementById("num-tarjeta-bancaria")
    let banco = document.getElementById("banco")
    let alias = document.getElementById("alias")
    let personaResponsable = document.getElementById("persona-responsable")


    if (listaCuentas != null && listaCuentas != "" && listaCuentas != undefined) {
        let jsonResponse = JSON.parse(listaCuentas)
        let cuentasBancarias = jsonResponse.cuentas_bancarias // lista de cuentas bancarias
        // Si la lista de contactos NO esta vacia, mostrara el contenedor de contactos y le asignara al indice de
        // contactos como valor, el total de cuentas bancarias actuales de la empresa
        if (cuentasBancarias.length > 0) {
            cuentasBancariasContainer.style.display = ""
            indiceCuentaBancaria = cuentasBancarias.length;
        }
        // Muestra las cuentas bancarias
        for (var indice = 0; indice < cuentasBancarias.length; indice++) {
            // Agrega el indice a la lista de indices de contactos agregados
            cuentasBancariasGuardadasIndice.push(indice);

            // Objeto que contendra los datos de la cuenta bancaria obtenida
            let cuentaBancariaObj = cuentasBancarias[indice]

            // --- Input que guardara el indice de la cuenta bancaria ---
            let indiceCBIH = document.createElement("input")
            indiceCBIH.value = indice

            // Variable que guarda localmente el indice de la cuenta bancaria
            let indiceCBTemp = indice;

            // ---- Clabe interbancaria ----
            let clabeInterbancariaInputHidden = document.createElement("input");
            clabeInterbancariaInputHidden.type = "hidden";
            clabeInterbancariaInputHidden.name = "clabe-interbancaria-" + indice;
            clabeInterbancariaInputHidden.value = cuentaBancariaObj.clabe_interbancaria;
            clabeInterbancariaInputHidden.id = "clabe-interbancaria-" + indice;

            // ---- Numero de cuenta bancaria ----
            let numCuentaBancariaInputHidden = document.createElement("input");
            numCuentaBancariaInputHidden.type = "hidden";
            numCuentaBancariaInputHidden.name = "num-cuenta-bancaria-" + indice;
            numCuentaBancariaInputHidden.value = cuentaBancariaObj.num_cuenta_bancaria;
            numCuentaBancariaInputHidden.id = "num-cuenta-bancaria-" + indice;

            // ---- Numero de tarjeta bancaria ----
            let numTarjetaBancariaInputHidden = document.createElement("input");
            numTarjetaBancariaInputHidden.type = "hidden";
            numTarjetaBancariaInputHidden.name = "num-tarjeta-bancaria-" + indice;
            numTarjetaBancariaInputHidden.value = cuentaBancariaObj.num_tarjeta_bancaria;
            numTarjetaBancariaInputHidden.id = "num-tarjeta-bancaria-" + indice;

            // ---- Banco ----
            let bancoInputHidden = document.createElement("input");
            bancoInputHidden.type = "hidden";
            bancoInputHidden.name = "banco-" + indice;
            bancoInputHidden.value = cuentaBancariaObj.banco;
            bancoInputHidden.id = "banco-" + indice;

            // ---- Alias ----
            let aliasInputHidden = document.createElement("input");
            aliasInputHidden.type = "hidden";
            aliasInputHidden.name = "alias-" + indice;
            aliasInputHidden.value = cuentaBancariaObj.alias;
            aliasInputHidden.id = "alias-" + indice;

            // --- Persona responsable ---
            let personaResponsableHidden = document.createElement("input");
            personaResponsableHidden.type = "hidden";
            personaResponsableHidden.name = "persona-responsable-" + indice;
            personaResponsableHidden.value = cuentaBancariaObj.persona_responsable;
            personaResponsableHidden.id = "persona-responsable-" + indice;

            // Agrega los inputs al formulario
            editarEmpresaForm.appendChild(clabeInterbancariaInputHidden);
            editarEmpresaForm.appendChild(numCuentaBancariaInputHidden);
            editarEmpresaForm.appendChild(numTarjetaBancariaInputHidden);
            editarEmpresaForm.appendChild(bancoInputHidden);
            editarEmpresaForm.appendChild(aliasInputHidden);
            editarEmpresaForm.appendChild(personaResponsableHidden);

            // Muestra en el listado de cuenta bancarias, el nombre del cuenta bancaria agregado recientemente

            // --- Crea el contenedor del elemento ---
            let containerElement = document.createElement("div");
            containerElement.setAttribute("data-index", indice); // establece el indice del cuenta bancaria guardado
            containerElement.classList.add("list-item-container");
            containerElement.style.cursor = "pointer";

            // --- Crea el elemento de texto ----
            let textElement = document.createElement("p");
            textElement.id = "c-b-nombre-elemento-" + indice;
            textElement.classList.add("list-item-text");
            textElement.textContent = aliasInputHidden.value;

            // --- Crea icono ---
            let iconElement = document.createElement("i")
            iconElement.classList.add("nav-icon")
            iconElement.classList.add('material-icons')
            iconElement.classList.add("list-item-icon");
            iconElement.appendChild(document.createTextNode("close"))
            iconElement.onclick = function () {
                // Elimina los input hidden
                editarEmpresaForm.removeChild(clabeInterbancariaInputHidden);
                editarEmpresaForm.removeChild(numCuentaBancariaInputHidden);
                editarEmpresaForm.removeChild(numTarjetaBancariaInputHidden);
                editarEmpresaForm.removeChild(bancoInputHidden);
                editarEmpresaForm.removeChild(aliasInputHidden)
                editarEmpresaForm.removeChild(personaResponsableHidden);

                // Obtiene los input hidden de las oficinas de la cuenta bancaria y los elimina
                let oficinasCB = document.querySelectorAll(`[data-indice-cuenta-bancaria="${indiceCBTemp}"]`)
                oficinasCB.forEach((item) => {
                    editarEmpresaForm.removeChild(item)
                })

                // Verifica si actualmente se esta modificando la cuenta bancaria que se va a eliminar,
                // de ser asi, borrarra los datos del formulario
                if (indiceCBTemp == indiceCuentaBancariaModificacion) {
                    // Borra los valores que se muestran en la UI
                    clabeInterbancaria.value = "";
                    numCuentaBancaria.value = "";
                    numTarjetaBancaria.value = "";
                    banco.value = "";
                    alias.value = "";
                    personaResponsable.value = "";

                    // Cambia texto del boton
                    $("#agregar-cuenta-bancaria-btn").text("+ Agregar otra cuenta bancaria");

                    // Reinicia el valor del indice de la cuenta bancaria actual
                    indiceCuentaBancariaModificacion = undefined;

                    // Elimina el input que contiene el indice de la cuenta bancaria que se va a modificar(Si es que existe)
                    let modificarCBIndiceInput = document.getElementById("modificar-c-b-indice")
                    if (modificarCBIndiceInput != null) {
                        editarEmpresaForm.removeChild(modificarCBIndiceInput)
                    }

                    // Desactiva los checkbox de las oficinas visualmente
                    deschecarOficinas();
                }


                // Elimina la cuenta bancaria de la lista visual (UI)
                cuentasBancariasContainer.removeChild(containerElement);

                // Si ya no hay mas cuentas bancarias, ocultara el texto del contenedor
                if (cuentasBancariasContainer.childElementCount == 1) // Si solo contiene la etiqueta <label>
                    cuentasBancariasContainer.style.display = "none";
            }


            // --- Agrega el elemento de texto al contenedor ---
            containerElement.appendChild(textElement);

            // --- Agrega elemento de icono --
            containerElement.appendChild(iconElement);

            // Agrega evento de click al contenedor del elemento
            containerElement.addEventListener("click", (evt) => {
                onCuentaBancariaClick(evt)
            }); // fin de evento de click en tarjeta de cuenta bancaria


            // Agrega el contenedor del cuenta bancaria al contenedor principal de los cuenta bancarias
            cuentasBancariasContainer.appendChild(containerElement);

            // **** Guarda las oficinas actuales de la cuenta bancaria en input hidden ****

            // --- Obtiene las oficinas de la cuenta bancaria ---
            let oficinasActuales = cuentaBancariaObj.oficinas

            for (let nombreOficina of oficinasActuales) {
                let oficinaInputHidden = document.createElement("input");
                oficinaInputHidden.type = "hidden";
                oficinaInputHidden.name = "oficinas-cuenta-bancaria-" + indice + "[]";
                oficinaInputHidden.value = nombreOficina;
                oficinaInputHidden.id = "oficina-cuenta-bancaria-" + indice;
                oficinaInputHidden.setAttribute("data-indice-cuenta-bancaria", indice)

                editarEmpresaForm.appendChild(oficinaInputHidden)
            }




        }
    }
}

// ** Funcion que deschekeara todas las oficinas del multiselect para las cuentas bancarias --
function deschecarOficinas() {
    let oficinaItems = document.querySelectorAll(".oficina-c-b-item")
    oficinaItems.forEach((item) => {
        if (item.classList.contains("checked"))
            item.click();
    })
}

// ** Funcion que se llama cuando se modifica una opcion de estatus **
function onEstatusChange(valueEstatus) {
    // Si selecciono el estatus 'Baja'
    if (valueEstatus == "Baja") {
        // Muestra 'Baja'
        $("#baja-container").css('display', 'block')
        $("#motivo-baja").prop('disabled', false)
        $("#motivo-baja").prop('required', true)
        $("#fecha-baja").prop('disabled', false)
        $("#fecha-baja").prop('required', true)
        // Oculta 'Lista negra'
        $("#lista-negra-container").css('display', 'none')
        $("#motivo-lista-negra").prop('disabled', true)
        $("#motivo-lista-negra").prop('required', false)
        $("#fecha-lista-negra").prop('disabled', true)
        $("#fecha-lista-negra").prop('required', false)
    } else if (valueEstatus == "Lista negra") {
        // Muestra 'Lista negra'
        $("#lista-negra-container").css('display', 'block')
        $("#motivo-lista-negra").prop('disabled', false)
        $("#motivo-lista-negra").prop('required', true)
        $("#fecha-lista-negra").prop('disabled', false)
        $("#fecha-lista-negra").prop('required', true)
        // Oculta 'Baja'
        $("#baja-container").css('display', 'none')
        $("#motivo-baja").prop('disabled', true)
        $("#motivo-baja").prop('required', false)
        $("#fecha-baja").prop('disabled', true)
        $("#fecha-baja").prop('required', false)
    } else {
        // Oculta 'Baja'
        $("#baja-container").css('display', 'none')
        $("#motivo-baja").prop('disabled', true)
        $("#motivo-baja").prop('required', false)
        $("#fecha-baja").prop('disabled', true)
        $("#fecha-baja").prop('required', false)

        $("#motivo-baja").val("")
        $("#fecha-baja").val(null)

        // Oculta 'Lista negra'
        $("#lista-negra-container").css('display', 'none')
        $("#motivo-lista-negra").prop('disabled', true)
        $("#motivo-lista-negra").prop('required', false)
        $("#fecha-lista-negra").prop('disabled', true)
        $("#fecha-lista-negra").prop('required', false)

        $("#motivo-lista-negra").val("")
        $("#fecha-lista-negra").val(null)
    }
}