// listado-colaboradores.js
COLABORADORES_PREFIX = `${BASE_URL}colaboradores`


// Funcion que eliminara un colaborador
async function eliminarColaborador(id) {
    // Pide al usuario que ingrese la contraseña
    requestPasswordTo({}, () => {
        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        // Muestra dialogo de confirmacion
        Swal.fire({
            title: "Eliminar colaborador",
            text: "¿Estas seguro de eliminar el colaborador?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            cancelButtonText: "Cancelar",
            confirmButtonText: "Si, eliminar!"
        }).then((result) => {
            if (result.isConfirmed) {
                showLoadingAlert("Eliminando colaborador...")
                // Elimina el colaborador
                $.ajax({
                    type: "POST",
                    url: `${COLABORADORES_PREFIX}/eliminar-colaborador`,
                    data: {
                        id: id
                    },
                    headers: {
                        "X-CSRFToken": csrftoken
                    },
                    success: function (data) {
                        Swal.close()
                        showActionConfirmAlert("¡Exito!", "Se elimino el colaborador correctamente", () => {
                            location.reload()
                        })
                    },
                    error: function (a, b, c) {
                        console.log(a, b, c)
                    }
                })
            }
        })



    })
}

// Funcion que mostrara un Popup que permitira al usuario modificar el estatus de un
// colaborador
async function changeColStatus(
    idCol,
    estatusList
) {
    //alert(estatusList)
    // TOKEN CSRF
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Convierte el listado de estatuses a un objeto JavaScript
    var estatusOptions = JSON.parse(estatusList)

    // Agrega los estatus correspondientes para seleccionar de la lista
    inputOptions = {}

    // Agrega los estatus a las opciones del select de la alerta
    $.each(estatusOptions, function (key, value) {
        inputOptions[value["fields"]["nombre"]] = value["fields"]["nombre"]
    })

    const { value: nuevo_estatus } = await Swal.fire(
        {
            title: "Seleccione un nuevo estatus",
            input: "select",
            inputOptions: inputOptions,
            confirmButtonText: 'Siguiente',
            inputPlaceholder: "Seleccione un nuevo estatus",
            showCancelButton: true,
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value == "") {
                        resolve("Seleccione un estatus")
                    } else {
                        resolve()
                    }
                })
            }
        }
    );

    if (nuevo_estatus) {
        showLoadingAlert("Modificando estatus...")

        if (nuevo_estatus == "Activo") {
            // Si el estatus seleccionado es activo, solamente cambiara
            // el estatus
            changeEstatus(idCol, nuevo_estatus)
        }
        if (nuevo_estatus == "Baja") {
            mostrarMotivoBaja(idCol)
        }
        if (nuevo_estatus == "Re-ingreso") {
            changeEstatus(idCol, nuevo_estatus)
        }
        if (nuevo_estatus == "Lista Negra") {
            mostrarMotivoListaNegra(idCol)
        }
        if (nuevo_estatus == "Vacaciones") {
            // Si el estatus seleccionado es vacaciones, solamente cambiara
            // el estatus
            //changeEstatus(idCol, nuevo_estatus)
            mostrarVacaciones(idCol)
        }
        if (nuevo_estatus == "Incapacidad") {
            mostrarIncapacidad(idCol)
        }
    }
}

async function changeEstatus(idCol, nuevo_estatus) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${COLABORADORES_PREFIX}/cambiar-estatus`,
            data: {
                id_col: idCol,
                nuevo_estatus: nuevo_estatus
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}

async function changeEstatusMotivoBaja(idCol, nuevo_estatus, motivoEstatus, fecha) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${COLABORADORES_PREFIX}/cambiar-estatus`,
            data: {
                id_col: idCol,
                nuevo_estatus: nuevo_estatus,
                motivo: motivoEstatus,
                fecha_baja: fecha
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}

async function changeEstatusMotivoListaNegra(idCol, nuevo_estatus, motivoEstatus) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();


    $.ajax(
        {
            type: "POST",
            url: `${COLABORADORES_PREFIX}/cambiar-estatus`,
            data: {
                id_col: idCol,
                nuevo_estatus: nuevo_estatus,
                motivo: motivoEstatus
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}

async function changeEstatusIncapacidad(formData) {

    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    $.ajax(
        {
            headers: { 'X-CSRFToken': csrftoken },
            method: 'post',
            url: `${COLABORADORES_PREFIX}/cambiar-estatus`,
            data: formData,
            processData: false,
            contentType: false,
            success: function (resp) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + b + c)
            }
        }
    )
}

// Funcion que cambiara el estatus del colaborador a un estatus pasado por el FormData de manera general
function changeEstatusGeneral(formData) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    $.ajax(
        {
            headers: { 'X-CSRFToken': csrftoken },
            method: 'post',
            url: `${COLABORADORES_PREFIX}/cambiar-estatus`,
            data: formData,
            processData: false,
            contentType: false,
            success: function (resp) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + b + c)
            }
        }
    )
}

// Funcion que mostrara un Popup con un campo de texto en donde el usuario podra escribir
// el motivo de el estatus Baja de un colaborador
async function mostrarMotivoBaja(idCol) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    Swal.fire({
        title: "Baja",
        html: `
        <label>Motivo de baja</label>
        <textarea name="motivo-baja" required placeholder="Escriba el motivo de la baja" value="" class="form-control" id="motivo" cols="30" rows="5"></textarea>
        <label>Fecha de baja</label>
        <br>
        <input type="date" value="${today}" id="fecha" required class="form-control" ></input>
        `,
        confirmButtonText: 'Cambiar estatus'
    }).then((result) => {
        if (result.isConfirmed) {
            changeEstatusMotivoBaja(idCol, "Baja", $("#motivo").val(), $("#fecha").val())
        }
    })

}

// Funcion que mostrara un Popup con un campo de texto en donde el usuario podra
//escribir el motivo de Lista negra de un colaborador
async function mostrarMotivoListaNegra(idCol) {
    Swal.fire({
        title: "Lista Negra",
        html: `
        <label>Motivo de lista negra</label>
        <textarea name="motivo-baja" required placeholder="Escriba el motivo de lista negra" value="" class="form-control" id="motivo" cols="30" rows="5"></textarea>
        `,
        confirmButtonText: 'Cambiar estatus'
    }).then(async (result) => {
        if (result.isConfirmed) {
            changeEstatusMotivoListaNegra(idCol, "Lista Negra", $("#motivo").val())
        }
    })
}

// Funcion que mostrara un Popup con un selector de archivo para el estatus de 'Incapacidad'
async function mostrarIncapacidad(idCol) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    Swal.fire({
        title: "Incapacidades",
        html: `
        <style>
            .periodo-container {
                width: 150px;
            }
            .periodos-container {
                display: flex;
                gap: 10px;
                justify-content: center
            }
        </style>
        <label>Archivo de incapacidad</label>
        <input type="file" class="swal2-file" id="file" style="display: flex"></input>
        <br>
        
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
                <label for="fecha1">Inicio de periodo</label>
                <input type="date" value="${today}" id="fecha1" required class="form-control" ></input>
            </div>
            <div class="periodo-container">
                <label for="fecha2">Fin de periodo</label>
                <input type="date" value="${today}" id="fecha2" required class="form-control" ></input>
            </div>
        </div>
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
            <label for="fecha1">Fecha de presentación</label>
            <input type="date" value="${today}" id="fecha-presentacion" required class="form-control" ></input>
            </div>
        </div>
        <br>

        <label>Número de dias de incapacidad</label>
        <input type="number" class="form-control" placeholder="Ingrese el número de dias" value="0" id="num-dias-incapacidad">
        `,
        confirmButtonText: 'Cambiar estatus',
        onBeforeOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });
        },

    }).then((result) => {
        if (result.isConfirmed) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                formData.append("archivo-incapacidad", file)
                formData.append("id_col", idCol)
                formData.append("fecha1_incapacidad", $("#fecha1").val())
                formData.append("fecha2_incapacidad", $("#fecha2").val())
                formData.append("fecha_presentacion_incapacidad", $("#fecha-presentacion").val())
                formData.append("num-dias-incapacidad", $("#num-dias-incapacidad").val())
                formData.append("nuevo_estatus", "Incapacidad")

                changeEstatusIncapacidad(formData)

            } else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        mostrarIncapacidad(idCol)
                    }
                })
            }
        }
    })
}

// Funcion que mostrara un Popup para el estatus de 'Vacaciones'
async function mostrarVacaciones(idCol) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    /* 
    
    <!--<label>Periodo de vacaciones</label>-->
    style="resize: horizontal; display: inline-block; margin-left: 80px"
    */

    Swal.fire({
        title: "Vacaciones",
        html: `
        <style>
            .periodo-container {
                width: 150px;
            }
            .periodos-container {
                display: flex;
                gap: 10px;
                justify-content: center
            }
        </style>
        <label>Archivo de vacaciones</label>
        <input type="file" class="swal2-file" id="file" style="display: flex"></input>
        <br>
        
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
                <label for="fecha1">Inicio de periodo</label>
                <input type="date" value="${today}" id="fecha1" required class="form-control" ></input>
            </div>
            <div class="periodo-container">
                <label for="fecha2">Fin de periodo</label>
                <input type="date" value="${today}" id="fecha2" required class="form-control" ></input>
            </div>
        </div>
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
            <label for="fecha1">Fecha de presentación</label>
            <input type="date" value="${today}" id="fecha-presentacion" required class="form-control" ></input>
            </div>
        </div>
        <br>

        <label><input type="checkbox" name="vacaciones-pagadas" id="vacaciones-pagadas"> Vacaciones Pagadas</label>
        <br>



        <label>Número de dias de vacaciones</label>
        <input type="number" class="form-control" min="0" placeholder="Ingrese el número de dias" value="0" id="num-dias-vacaciones">
        `,
        confirmButtonText: 'Cambiar estatus',
        onBeforeOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });
        },

    }).then((result) => {
        if (result.isConfirmed) {
            //if ($(".swal2-file")[0].files[0]) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                vacacionesPagadas = null
                if ($("#vacaciones-pagadas").is(":checked")) {
                    vacacionesPagadas = "Pagadas"
                }
                formData.append("id_col", idCol)
                formData.append("fecha1_vacaciones", $("#fecha1").val())
                formData.append("fecha2_vacaciones", $("#fecha2").val())
                formData.append("fecha_presentacion_vacaciones", $("#fecha-presentacion").val())
                formData.append("num-dias-vacaciones", $("#num-dias-vacaciones").val())
                formData.append("vacaciones-file", file)
                // Si el usuario MARCO EL CHECKBOX, agregara al FormData el valor que significa que
                // las vacaciones son pagadas
                if (vacacionesPagadas != null) {
                    formData.append("vacaciones_pagadas", vacacionesPagadas)
                }
                formData.append("nuevo_estatus", "Vacaciones")

                changeEstatusGeneral(formData)
                //changeEstatusIncapacidad(formData)
            }
            else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        mostrarVacaciones(idCol)
                    }
                })
            }
        }
    })
}

// Funcion que exportara el listado a excel
async function exportarExcel(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = ""

    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = []

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
        estatusListQuery = searchResponseO["estatus_list_query"] || []
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    // Criterio de busqueda
    var query = $("#query").val()

    let url = `${COLABORADORES_PREFIX}/listado-colaboradores?`
    let searchParams = new URLSearchParams({
        query: query,
        //oficina: oficina,
        //estatus: estatus,
        exportar_excel: "true"
    })

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel
    for (let estatus of estatusListQuery) {
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url, {
        headers: {
            "x-requested-with": "XMLHttpRequest"
        }
    })

    if (!result.ok) {
        let errorJson = await result.json()
        console.log(errorJson)
    }

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte colaboradores.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()

}

// Funcion que exportara el listado a PDF
async function exportarPdf(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = ""

    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = []

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
        estatusListQuery = searchResponseO["estatus_list_query"] || []
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    var query = $("#query").val()

    let url = `${COLABORADORES_PREFIX}/listado-colaboradores?`
    let searchParams = new URLSearchParams({
        query: query,
        //oficina: oficina,
        //estatus: estatus,
        exportar_pdf: "true"
    })

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel

    for (let estatus of estatusListQuery) {
        //searchParams.append("estatus-query" + encodeURIComponent("[") + encodeURIComponent("]"), estatus)
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        //searchParams.append("oficinas-query" + encodeURIComponent("[") + encodeURIComponent("]"), oficina)
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url, {
        headers: {
            "x-requested-with": "XMLHttpRequest"
        }
    })

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte colaboradores.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

