// Funcion que exportara el listado a excel
async function exportarExcel(
) {
    var query = $("#query").val()
    var estatus = $("#estatus").val()
    var oficina = $("#oficina").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-vehiculos?` + new URLSearchParams({
            query: query,
            estatus: estatus,
            oficina: oficina,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte vehiculos.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var estatus = $("#estatus").val()
    var oficina = $("#oficina").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-vehiculos?` + new URLSearchParams({
            query: query,
            estatus: estatus,
            oficina: oficina,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte vehiculos.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que mostrara una alerta que permitira cambiar el estatus a un vehiculo
async function showChangeStatusAlert(
    vehiculoId,
    estatusList
) {
    // TOKEN CSRF
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Convierte el listado de estatuses a un objeto JavaScript
    var estatusOptions = JSON.parse(estatusList)

    // Agrega los estatus correspondientes para seleccionar de la lista
    inputOptions = {}

    // Agrega los estatus a las opciones del select de la alerta
    $.each(estatusOptions, function (key, value) {
        inputOptions[value["fields"]["vehiculo_estatus_nombre"]] = value["fields"]["vehiculo_estatus_nombre"]
    })

    const { value: nuevoEstatus } = await Swal.fire(
        {
            title: "Seleccione un nuevo estatus",
            input: "select",
            inputOptions: inputOptions,
            confirmButtonText: 'Cambiar',
            confirmButtonColor: "#227CE6",
            cancelButtonText: "Cancelar",
            inputPlaceholder: "Seleccione un nuevo estatus",
            showCancelButton: true,
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value == "") {
                        resolve("Seleccione un estatus")
                    } else {
                        resolve()
                    }
                })
            }
        }
    );

    if (nuevoEstatus) {
        // Muestra alerta de carga
        showLoadingAlert("Cambiando estatus...")
        $.ajax(
            {
                type: "POST",
                url: `${FLOTILLAS_PREFIX}/cambiar-vehiculo-estatus`,
                data: {
                    vehiculoId: vehiculoId,
                    nuevoEstatus: nuevoEstatus
                },
                headers: {
                    "X-CSRFToken": csrftoken
                },
                success: function (data) {
                    Swal.close() // Oculta la alerta de carga
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se modifico el estatus exitosamente.",
                            icon: 'success',
                            confirmButtonColor: "#227CE6",
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            location.reload()
                        }
                    })
                },
                error: function (a, b, c) {
                    alert(a + " " + b + "" + c)
                }
            }
        )
    }
}