// subir-documentos-col.js

const COLABORADORES_PREFIX = `${BASE_URL}colaboradores`

// Crea una variable llamada clone para guardar el clon de el valor del input
var clone = {};

// Funcion que eliminara un archivo de un tipo de documento de un cliente en especifico
function eliminarDocColaborador(
    colaboradorId,
    codigoTipoDocumento,
    nombreCarpetaDoc
) {
    // Mostrara una alerta de confirmacion al usuario
    Swal.fire({
        title: "Eliminar archivo",
        text: "¿Estas seguro de eliminar el archivo? Esta acción es definitiva y no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Si, eliminar!"
    }).then((result) => {
        if (result.isConfirmed) {
            // Muestra alerta de carga
            showLoadingAlert("Eliminando archivo...")

            // Comienza proceso de eliminacion
            var csrftoken = $("[name=csrfmiddlewaretoken]").val();

            $.ajax(
                {
                    method: "POST",
                    url: `${COLABORADORES_PREFIX}/subir-documentos-col/${colaboradorId}`,
                    headers: { 'X-CSRFToken': csrftoken },
                    data: {
                        colaboradorId: colaboradorId,
                        codigoTipoDocumento: codigoTipoDocumento,
                        eliminarArchivo: true
                    },
                    success: function (data) {
                        // Cierra las alertas actuales
                        Swal.close()

                        // Muestra alerta de exito
                        Swal.fire(
                            {
                                title: "¡Exito!",
                                text: "Se elimino el archivo exitosamente",
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }
                        )
                        // Oculta el check de estatus
                        $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
                        // Elimina el valor del <input> de tipo 'file'
                        $(`#${nombreCarpetaDoc}-input`).val(null)
                        // Desactiva el boton de eliminar
                        $(`#${nombreCarpetaDoc}-del-btn`).attr("disabled", "disabled")
                        //$(`#${nombreCarpetaDoc}-del-btn`).on('click', function () { })
                        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
                        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')

                        // Indica que el archivo de este tipo de documento se elimino recientemente
                        $(`#file-del-${nombreCarpetaDoc}`).val("T")

                        // Reinicia el input date(Vigencia)
                        $(`#vigencia-${nombreCarpetaDoc}`).val(null)
                        // Reinicia el input text(Observaciones)
                        $(`#observaciones-${nombreCarpetaDoc}`).val("")

                    },
                    error: function (a, b, c) {
                        alert(a + b + c)
                    }
                }
            )
        }
    })
}

// Funcion que se invocara cuando el input de tipo 'file' de cada tipo de documento
// cambie
function onDocInputFileChange(
    event,
    nombreCarpetaDoc
) {
    $(document).ready(function () {
        //alert(nombreTipoDocumento)
        // Muestra el check de estatus de el tipo de documento
        $(`#${nombreCarpetaDoc}-check`).css('display', 'block')

        // Muestra disponible el boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass('disabled-table-icon')
        $(`#${nombreCarpetaDoc}-del-select-btn`).addClass("table-icon")

        // Muestra desactivado el boton de 'eliminar archivo'
        $(`#${nombreCarpetaDoc}-del-btn`).removeClass("table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).addClass("disabled-table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')

        // Hace que el input de tipo date 'Vigencia' sea obligatorio
        //$(`#vigencia-${nombreCarpetaDoc}`).prop('required', true)

        // Evento de click al boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).on('click', function () {
            // Oculta el check de estatus
            $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
            // Elimina el valor del <input> de tipo 'file'
            $(`#${nombreCarpetaDoc}-input`).val(null)
            // Boton de eliminar seleccion
            $(`#${nombreCarpetaDoc}-del-select-btn`).addClass('disabled-table-icon')
            $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass("table-icon")

            $(`#${nombreCarpetaDoc}-del-select-btn`).off('click')

            // Hace que el input de tipo date 'Vigencia' NO sea obligatorio 
            //$(`#vigencia-${nombreCarpetaDoc}`).prop('required', false)
            // Reinicia el input date(Vigencia)
            $(`#vigencia-${nombreCarpetaDoc}`).val(null)
            // Reinicia el input text(Observaciones)
            $(`#observaciones-${nombreCarpetaDoc}`).val("")



        })

        //$(`#${nombreCarpetaDoc}-del-btn`).toggleClass("disabled-table-icon table-icon")
        /*
        $(`#${nombreCarpetaDoc}-del-btn`).on('click', function () {
            eliminarDocCliente(clienteId, codigoDocumento, nombreCarpetaDoc, archivoSubido)
        })
        */
    })

    // -- Solucion bug al dar click en el boton de 'Cancelar' --
    var fileElement = event.target,
        files = fileElement.files
    //alert(fileElement.id)
    if (fileElement.value == "") { // solamente si el valor estuviera vacio(dio click en cancelar) restaura el valor
        //alert("Presiono cancelar")
        clone[fileElement.id].insertBefore(fileElement);
        $(fileElement).remove()
    }

}


// Metodo que clonara el archivo de algun input file para recuperarlo en caso de que el usuario
// de click en el boton 'Cancelar' al abrir el dialogo de seleccion de archivo
//inputClicked()
function inputClicked(event) {
    var fileElement = event.target
    if (fileElement.value != "") {
        console.log("Clone( #" + fileElement.id + " ) : " + fileElement.value.split("\\").pop())
        clone[fileElement.id] = $(fileElement).clone() // Clona el valor del input
    }
}

// Funcion que se invocara cuando cambie el checkbox de 'No aplica'
function onNoAplicaChange(
    event,
    colaboradorId,
    codigoTipoDocumento,
    nombreCarpetaDoc,
    cargado,
    noAplica
) {


    // Desactiva el tipo de documento
    if (event.target.checked == true) {
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', true)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', true)
        $(`#${nombreCarpetaDoc}-input`).attr('disabled', "disabled")
        //$(`#${nombreCarpetaDoc}-check`).css('display', 'none')
        //alert(`#${nombreCarpetaDoc}-del-btn`)
        $(`#${nombreCarpetaDoc}-del-btn`).attr('disabled', "disabled")
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("onclick")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
    } else {
        // Activa el tipo de documento
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', false)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', false)
        $(`#${nombreCarpetaDoc}-input`).prop('disabled', false)
        // Si en el registro de documento hay un archivo cargado actualmente
        // el documento originalmente no tenia activada la opcion de 'No aplica'
        // no elimino el archivo recientemente
        let deletedRecent = $(`#file-del-${nombreCarpetaDoc}`).val() // 'T' o 'F'
        if (cargado == "True" && noAplica == "False" && deletedRecent == "F") {
            $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("disabled")
            $(`#${nombreCarpetaDoc}-del-btn`).on('click', () => {
                eliminarDocColaborador(colaboradorId, codigoTipoDocumento, nombreCarpetaDoc)
            })
        }
    }
}

// Funcion que realizara una llamada AJAX para modificar el registro de una vacacion o incapacidad de un colaborador
function cambiarRegistroEstatus(formData, colId) {
    showLoadingAlert("Modificando registro...")
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    $.ajax(
        {
            headers: { 'X-CSRFToken': csrftoken },
            method: 'post',
            url: `${COLABORADORES_PREFIX}/subir-documentos-col/${colId}`,
            data: formData,
            processData: false,
            contentType: false,
            success: function (resp) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el registro correctamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + b + c)
            }
        }
    )
}


function modificarRegistroVacaciones(
    idRegistroVacaciones,
    colId,
    fecha1Actual,
    fecha2Actual,
    fechaPresentacionActual,
    vacacionesPagadasActual,
    numDiasActual
) {
    Swal.fire({
        title: "Modificar registro de vacaciones",
        html: `
        <style>
            .periodo-container {
                width: 150px;
            }
            .periodos-container {
                display: flex;
                gap: 10px;
                justify-content: center
            }
        </style>
        <label>Archivo de vacaciones</label>
        <input type="file" class="swal2-file" id="file" style="display: flex"></input>
        <br>
        
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
                <label for="fecha1">Inicio de periodo</label>
                <input type="date"  id="fecha1" required class="form-control" ></input>
            </div>
            <div class="periodo-container">
                <label for="fecha2">Fin de periodo</label>
                <input type="date"  id="fecha2" required class="form-control" ></input>
            </div>
        </div>
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
            <label for="fecha1">Fecha de presentación</label>
            <input type="date"  id="fecha-presentacion" required class="form-control" ></input>
            </div>
        </div>
        <br>

        <label><input type="checkbox" name="vacaciones-pagadas" id="vacaciones-pagadas"> Vacaciones Pagadas</label>
        <br>



        <label>Número de dias de vacaciones</label>
        <input type="number" class="form-control" min="0" placeholder="Ingrese el número de dias" value="0" id="num-dias-vacaciones">
        `,
        confirmButtonText: 'Modificar registro',
        willOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });


        },
        didOpen: () => {
            console.log("Hola onOpen")
            // Establece los valores actuales del registro de vacaciones
            $("#fecha1").val(fecha1Actual)
            $("#fecha2").val(fecha2Actual)
            $("#fecha-presentacion").val(fechaPresentacionActual)
            $("#num-dias-vacaciones").val(numDiasActual)

            if (vacacionesPagadasActual == 1) {
                $("#vacaciones-pagadas").prop('checked', true)
            }
        },

    }).then((result) => {
        if (result.isConfirmed) {
            //if ($(".swal2-file")[0].files[0]) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                vacacionesPagadas = null
                if ($("#vacaciones-pagadas").is(":checked")) {
                    vacacionesPagadas = "Pagadas"
                }
                formData.append("fecha1", $("#fecha1").val())
                formData.append("fecha2", $("#fecha2").val())
                formData.append("fecha_presentacion", $("#fecha-presentacion").val())
                formData.append("num-dias", $("#num-dias-vacaciones").val())
                formData.append("vacaciones-file", file)
                // Si el usuario MARCO EL CHECKBOX, agregara al FormData el valor que significa que
                // las vacaciones son pagadas
                if (vacacionesPagadas != null) {
                    formData.append("vacaciones_pagadas", vacacionesPagadas)
                }
                // Indica el tipo de estatus del que se va a modificar su registro
                formData.append("estatus", "Vacaciones")
                // Envia el id del registro
                formData.append("registro_id", idRegistroVacaciones)
                // Indica que se quiere modificar un registro de estatus
                formData.append("modificarRegistroEstatus", true)

                cambiarRegistroEstatus(formData, colId)

            }
            else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        modificarRegistroVacaciones(
                            idRegistroVacaciones,
                            colId,
                            fecha1Actual,
                            fecha2Actual,
                            fechaPresentacionActual,
                            vacacionesPagadasActual,
                            numDiasActual
                        )
                    }
                })
            }
        }
    })
}

function eliminarRegistroEstatus(idRegistroVacaciones, tipoEstatus, colId) {
    // Mostrara una alerta de confirmacion al usuario
    Swal.fire({
        title: "Eliminar registro",
        text: "¿Estas seguro de eliminar el registro? Esta acción es definitiva y no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Si, eliminar!"
    }).then((result) => {
        if (result.isConfirmed) {
            showLoadingAlert("Eliminando registro...")
            var csrftoken = $("[name=csrfmiddlewaretoken]").val();

            let formData = new FormData()
            formData.append("eliminarRegistroEstatus", true)
            formData.append("estatus", tipoEstatus)
            formData.append("registro_id", idRegistroVacaciones)

            $.ajax({
                headers: { 'X-CSRFToken': csrftoken },
                method: 'post',
                url: `${COLABORADORES_PREFIX}/subir-documentos-col/${colId}`,
                data: formData,
                processData: false,
                contentType: false,
                success: function (resp) {
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se elimino el registro correctamente.",
                            icon: 'success',
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            location.reload()
                        }
                    })
                },
                error: function (a, b, c) {
                    alert(a + b + c)
                }
            })
        }
    })

}

function modificarRegistroIncapacidad(
    idRegistroIncapacidad,
    colId,
    fecha1Actual,
    fecha2Actual,
    fechaPresentacionActual,
    numDiasActual
) {
    Swal.fire({
        title: "Modificar registro de incapacidad",
        html: `
        <style>
            .periodo-container {
                width: 150px;
            }
            .periodos-container {
                display: flex;
                gap: 10px;
                justify-content: center
            }
        </style>
        <label>Archivo de incapacidad</label>
        <input type="file" class="swal2-file" id="file" style="display: flex"></input>
        <br>
        
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
                <label for="fecha1">Inicio de periodo</label>
                <input type="date"  id="fecha1" required class="form-control" ></input>
            </div>
            <div class="periodo-container">
                <label for="fecha2">Fin de periodo</label>
                <input type="date"  id="fecha2" required class="form-control" ></input>
            </div>
        </div>
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
            <label for="fecha1">Fecha de presentación</label>
            <input type="date"  id="fecha-presentacion" required class="form-control" ></input>
            </div>
        </div>
        <br>

        <label>Número de dias de incapacidad</label>
        <input type="number" class="form-control" placeholder="Ingrese el número de dias" value="0" id="num-dias-incapacidad">
        `,
        confirmButtonText: 'Modificar registro',
        willOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });


        },
        didOpen: () => {
            console.log("Hola onOpen")
            // Establece los valores actuales del registro de vacaciones
            $("#fecha1").val(fecha1Actual)
            $("#fecha2").val(fecha2Actual)
            $("#fecha-presentacion").val(fechaPresentacionActual)
            $("#num-dias-incapacidad").val(numDiasActual)
        },

    }).then((result) => {
        if (result.isConfirmed) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                formData.append("archivo-incapacidad", file)
                formData.append("fecha1", $("#fecha1").val())
                formData.append("fecha2", $("#fecha2").val())
                formData.append("fecha_presentacion", $("#fecha-presentacion").val())
                formData.append("num-dias", $("#num-dias-incapacidad").val())

                // Indica el tipo de estatus del que se va a modificar su registro
                formData.append("estatus", "Incapacidad")
                // Envia el id del registro
                formData.append("registro_id", idRegistroIncapacidad)
                // Indica que se quiere modificar un registro de estatus
                formData.append("modificarRegistroEstatus", true)

                cambiarRegistroEstatus(formData, colId)

            } else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        modificarRegistroIncapacidad(
                            idRegistroIncapacidad,
                            colId,
                            fecha1Actual,
                            fecha2Actual,
                            fechaPresentacionActual,
                            numDiasActual
                        )
                    }
                })
            }
        }
    })
}

// Funcion que agregara un nuevo registro de un tipo de estatus (Vacaciones, Incapacidades)
function agregarNuevoRegistro(formData, colId) {
    showLoadingAlert('Agregando nuevo registro...')

    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    $.ajax(
        {
            headers: { 'X-CSRFToken': csrftoken },
            method: 'post',
            url: `${COLABORADORES_PREFIX}/subir-documentos-col/${colId}`,
            data: formData,
            processData: false,
            contentType: false,
            success: function (resp) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se agrego el registro correctamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + b + c)
            }
        }
    )
}


// Funcion que se llamara cuando el usuario requiera agregar un nuevo registro de vacaciones
function agregarNuevoRegistroVacaciones(
    colId
) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    /* 
    
    <!--<label>Periodo de vacaciones</label>-->
    style="resize: horizontal; display: inline-block; margin-left: 80px"
    */

    Swal.fire({
        title: "Agregar nuevo registro de vacaciones",
        html: `
        <style>
            .periodo-container {
                width: 150px;
            }
            .periodos-container {
                display: flex;
                gap: 10px;
                justify-content: center
            }
        </style>
        <label>Archivo de vacaciones</label>
        <input type="file" class="swal2-file" id="file" style="display: flex"></input>
        <br>
        
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
                <label for="fecha1">Inicio de periodo</label>
                <input type="date" value="${today}" id="fecha1" required class="form-control" ></input>
            </div>
            <div class="periodo-container">
                <label for="fecha2">Fin de periodo</label>
                <input type="date" value="${today}" id="fecha2" required class="form-control" ></input>
            </div>
        </div>
        <br>
        <div class="parent periodos-container">
            <div class="periodo-container">
            <label for="fecha1">Fecha de presentación</label>
            <input type="date" value="${today}" id="fecha-presentacion" required class="form-control" ></input>
            </div>
        </div>
        <br>

        <label><input type="checkbox" name="vacaciones-pagadas" id="vacaciones-pagadas"> Vacaciones Pagadas</label>
        <br>



        <label>Número de dias de vacaciones</label>
        <input type="number" class="form-control" min="0" placeholder="Ingrese el número de dias" value="0" id="num-dias-vacaciones">
        `,
        confirmButtonText: 'Agregar registro',
        onBeforeOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });
        },

    }).then((result) => {
        if (result.isConfirmed) {
            //if ($(".swal2-file")[0].files[0]) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                vacacionesPagadas = null
                if ($("#vacaciones-pagadas").is(":checked")) {
                    vacacionesPagadas = "Pagadas"
                }
                formData.append("col_id", colId)
                formData.append("fecha1", $("#fecha1").val())
                formData.append("fecha2", $("#fecha2").val())
                formData.append("fecha_presentacion", $("#fecha-presentacion").val())
                formData.append("num-dias", $("#num-dias-vacaciones").val())
                formData.append("vacaciones-file", file)
                // Si el usuario MARCO EL CHECKBOX, agregara al FormData el valor que significa que
                // las vacaciones son pagadas
                if (vacacionesPagadas != null) {
                    formData.append("vacaciones_pagadas", vacacionesPagadas)
                }

                // Indica que se quiere agregar un nuevo registro de un tipo de estatus
                formData.append("agregarNuevoRegistroEstatus", true)

                // Indica que se quiere agregar un registro de el tipo de estatus 'Vacaciones'
                formData.append("estatus", "Vacaciones")

                agregarNuevoRegistro(formData, colId)
                //changeEstatusIncapacidad(formData)
            }
            else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        agregarNuevoRegistroVacaciones(colId)
                    }
                })
            }
        }
    })
}

// Funcion que se llamara cuando el usuario requiera agregar un nuevo registro de incapacidades
function agregarNuevoRegistroIncapacidad(colId) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    Swal.fire({
        title: "Agregar nuevo de registro de incapacidad",
        html: `
            <style>
                .periodo-container {
                    width: 150px;
                }
                .periodos-container {
                    display: flex;
                    gap: 10px;
                    justify-content: center
                }
            </style>
            <label>Archivo de incapacidad</label>
            <input type="file" class="swal2-file" id="file" style="display: flex"></input>
            <br>
            
            <br>
            <div class="parent periodos-container">
                <div class="periodo-container">
                    <label for="fecha1">Inicio de periodo</label>
                    <input type="date" value="${today}" id="fecha1" required class="form-control" ></input>
                </div>
                <div class="periodo-container">
                    <label for="fecha2">Fin de periodo</label>
                    <input type="date" value="${today}" id="fecha2" required class="form-control" ></input>
                </div>
            </div>
            <br>
            <div class="parent periodos-container">
                <div class="periodo-container">
                <label for="fecha1">Fecha de presentación</label>
                <input type="date" value="${today}" id="fecha-presentacion" required class="form-control" ></input>
                </div>
            </div>
            <br>

            <label>Número de dias de incapacidad</label>
            <input type="number" class="form-control" placeholder="Ingrese el número de dias" value="0" id="num-dias-incapacidad">
    `,
        confirmButtonText: 'Agregar registro',
        onBeforeOpen: () => {
            $(".swal2-file").change(function () {
                var reader = new FileReader();
                reader.readAsDataURL(this.files[0]);
            });
        },

    }).then((result) => {
        if (result.isConfirmed) {
            if ($("#fecha1").val() != "" && $("#fecha2").val() != "" && $("#fecha-presentacion").val() != "") {
                var formData = new FormData()
                var file = $(".swal2-file")[0].files[0]
                formData.append("archivo-incapacidad", file)
                formData.append("col_id", colId)
                formData.append("fecha1", $("#fecha1").val())
                formData.append("fecha2", $("#fecha2").val())
                formData.append("fecha_presentacion", $("#fecha-presentacion").val())
                formData.append("num-dias", $("#num-dias-incapacidad").val())

                // Indica que se quiere agregar un nuevo registro de un tipo de estatus
                formData.append("agregarNuevoRegistroEstatus", true)

                // Indica que se quiere agregar un registro de el tipo de estatus 'Vacaciones'
                formData.append("estatus", "Incapacidad")

                agregarNuevoRegistro(formData, colId)

            } else {
                Swal.fire(
                    {
                        title: "¡Atencion!",
                        text: "Debe rellenar todos los campos requeridos.",
                        icon: "error"
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        agregarNuevoRegistroIncapacidad(colId)
                    }
                })
            }
        }
    })
}