// subir-documentos-provedor.js

// Constante que representa a la aplicacion provedores en URL
const provedores = `${BASE_URL}provedores`


// Arreglo que guardara los archivos seleccionados de manera global
var filesSelected = []

// Contenedor de los archivos subidos
var contratosContainer = document.getElementById("contracts-container")

// Funcion que mostrara un contenedor con el nombre de un archivo seleccionado
function showFileSelected(file) {
    // Crea un container para el archivo seleccionado
    var div = document.createElement("div")

    div.setAttribute(
        "style",
        "background: none;border: 1px solid #cccccc;padding: 0.7em; padding-top:0.1em;padding-bottom:0;width:auto;margin-bottom: 15px; height: auto;display: flex;position:relative;"
    );

    // Crea un <p> para el nombre del archivo seleccionado
    var pName = document.createElement("p")
    pName.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
        width: 65%; 
        `
    );
    pName.textContent = `${file.name}`;

    // Crea otro <p> para el tamaño del archivo seleccionado
    /*
    var pSize = document.createElement("p")
    pSize.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;`
    );
    pSize.textContent = `(${returnFileSize(file.size)})`;
    */

    // Crea otro <p> para mostrar la extension de el archivo seleccionado
    var pExtension = document.createElement("p")
    pExtension.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;`
    )
    pExtension.textContent = `(${file.name.split('.').pop()})`

    // Inserta los elementos correspondientes
    //li.appendChild(document.createTextNode("Holaaa"))

    // Crea un <i> en donde se mostrara el icono
    var i = document.createElement("i")
    i.classList.add("nav-icon")
    i.classList.add('material-icons')
    i.setAttribute(
        "style",
        `font-size: 2em;cursor:pointer;
        flex: 2;
        text-align: end;
        vertical-align: middle;
        position: absolute;
        top: 50%;
        left: 90%;
        transform: translate(0,-50%);
        margin-left: 0.5em;`
    )
    i.appendChild(document.createTextNode("close"))

    // Evento onclick para la X
    i.onclick = function () {
        // Elimina el div
        contratosContainer.removeChild(div)
        // Elimina el archivo de la lista
        filesSelected = filesSelected.filter(e => e !== file)
        //filesSelected.splice(i,1)
        console.log("heyyy")
        console.log(filesSelected)
    }

    div.appendChild(pName)
    div.appendChild(pExtension)
    //div.appendChild(pSize)
    div.appendChild(i)

    contratosContainer.insertBefore(div, null)
}

// Variable en donde se guardara el clon de archivo de algun input file para posteriormente
// recuperar este valor y guardarlo nuevamente
var clone = {};

// MODULO DE SUBIR ARCHIVOS DE CONTRATO
window.onload = function () { // Cuando la ventana se cargue ejecutara este bloque de codigo
    // Checa el soporte de la API File

    if (window.File && window.FileList && window.FileReader) {
        // Variable donde se asignara el <input> tipo 'file' que servira para seleccionar archivos
        var filesInput = document.getElementById("contratos-files")
        filesInput.addEventListener("change", function (event) {
            console.log("CAMBIO EL INPUT NIMODO")
            // Objeto de FileList
            var files = event.target.files
            for (var i = 0; i < files.length; i++) {
                var file = files[i]
                // Si el archivo seleccionado, ya lo habia seleccionado antes, no hara nada
                if (!filesSelected.filter(e => e.name === file.name).length > 0) {
                    console.log("HEY HOLA -> " + i.toString())
                    // Verifica que el archivo sea PDF
                    if (isPdf(file) || isWord(file)) {

                        // Agrega el archivo seleccionado a el array temporal
                        filesSelected.push(file)
                        // Muestra en la UI el archivo seleccionado
                        showFileSelected(file)
                        console.log("HEYYY SE SELECCIONO")
                    } else {
                        // Si no es PDF mostrara una alerta de error
                        showFailAlert("¡Atención!", "Solo se permiten archivos PDF o WORD")
                    }
                }
            }
        })
    }
}


// ------------- 'subir-documentos-provedor.html' ------------------

// Funcion que recuperara cierto archivo de contrato pasado por parametro y lo mostrara en la UI 
async function recoverContratosFiles(url) {
    const fileObj = await createFileFromUrl(url)

    filesSelected.push(fileObj)
    showFileSelected(fileObj)
    console.log(`HEYYY -> ${fileObj.name}`)
}

function checkContratoFormEdit() {
    showLoadingAlert('Subiendo/Remplazando documentos...')
    $("#submit-form-btn").prop('disabled', true)
    setSelectedFilesToInput("contratos-files")
    $("#subir-doc-provedor-form").submit()
}

// Evento que se llamara cuando el formulario de 'subir-documento-provedor.html' se empieze a subir
$('#subir-doc-provedor-form').submit(function (evt) {
    // Evitara que se suba el formulario
    evt.preventDefault();
    checkContratoFormEdit()
});


// Funcion que asignara los posibles contratos subidos a un input file en especifico
function setSelectedFilesToInput(inputId) {
    let dataTransfer = new DataTransfer()
    // Cargara los posibles contratos en el input multiple
    for (const file of filesSelected) {
        dataTransfer.items.add(file)
    }
    var inputFile = document.getElementById(inputId)
    inputFile.files = dataTransfer.files
}


function clearAllSelectedFiles() {
    filesSelected = []
    console.log(filesSelected)
}

// --- AJAX -----

// Funcion que eliminara un archivo de un tipo de documento de un provedor en especifico
function eliminarDocProvedor(
    provedorId,
    codigoTipoDocumento,
    nombreCarpetaDoc
) {
    // Mostrara una alerta de confirmacion al usuario
    Swal.fire({
        title: "Eliminar archivo",
        text: "¿Estas seguro de eliminar el archivo? Esta acción es definitiva y no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Si, eliminar!"
    }).then((result) => {
        if (result.isConfirmed) {
            // Muestra alerta de carga
            showLoadingAlert("Eliminando archivo...")

            // Comienza proceso de eliminacion
            var csrftoken = $("[name=csrfmiddlewaretoken]").val();


            $.ajax(
                {
                    method: "POST",
                    url: `${provedores}/subir-documentos-provedor/${provedorId}`,
                    headers: { 'X-CSRFToken': csrftoken },
                    data: {
                        provedorId: provedorId,
                        codigoTipoDocumento: codigoTipoDocumento,
                        eliminarArchivo: true
                    },
                    success: function (data) {
                        // Cierra las alertas actuales
                        Swal.close()

                        // Muestra alerta de exito
                        Swal.fire(
                            {
                                title: "¡Exito!",
                                text: "Se elimino el archivo exitosamente",
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }
                        )
                        // Oculta el check de estatus
                        $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
                        // Elimina el valor del <input> de tipo 'file'
                        $(`#${nombreCarpetaDoc}-input`).val(null)
                        // Desactiva el boton de eliminar
                        //$(`#${nombreCarpetaDoc}-del-btn`).removeClass("table-icon")
                        //$(`#${nombreCarpetaDoc}-del-btn`).addClass("disabled-table-icon")
                        //$(`#${nombreCarpetaDoc}-del-btn`).on('click', function () { })
                        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
                        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')
                        $(`#${nombreCarpetaDoc}-del-btn`).attr('disabled', 'disabled')

                        // Indica que el archivo de este tipo de documento se elimino recientemente
                        $(`#file-del-${nombreCarpetaDoc}`).val("T")

                        // Reinicia el input date(Vigencia)
                        $(`#vigencia-${nombreCarpetaDoc}`).val(null)
                        // Reinicia el input text(Observaciones)
                        $(`#observaciones-${nombreCarpetaDoc}`).val("")
                    },
                    error: function (a, b, c) {
                        alert(a + b + c)
                    }
                }
            )
        }
    })
}

// Funcion que se invocara cuando el input de tipo 'file' de cada tipo de documento
// cambie
function onDocInputFileChange(
    event,
    nombreCarpetaDoc
) {
    $(document).ready(function () {
        //alert(nombreTipoDocumento)
        // Muestra el check de estatus de el tipo de documento
        $(`#${nombreCarpetaDoc}-check`).css('display', 'block')

        // Muestra disponible el boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass('disabled-table-icon')
        $(`#${nombreCarpetaDoc}-del-select-btn`).addClass("table-icon")

        // Muestra desactivado el boton de 'eliminar archivo'
        $(`#${nombreCarpetaDoc}-del-btn`).removeClass("table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).addClass("disabled-table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')

        // Evento de click al boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).on('click', function () {
            // Oculta el check de estatus
            $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
            // Elimina el valor del <input> de tipo 'file'
            $(`#${nombreCarpetaDoc}-input`).val(null)
            // Boton de eliminar seleccion
            $(`#${nombreCarpetaDoc}-del-select-btn`).addClass('disabled-table-icon')
            $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass("table-icon")

            $(`#${nombreCarpetaDoc}-del-select-btn`).off('click')

            // Hace que el input de tipo date 'Vigencia' NO sea obligatorio 
            //$(`#vigencia-${nombreCarpetaDoc}`).prop('required', false)
            // Reinicia el input date(Vigencia)
            $(`#vigencia-${nombreCarpetaDoc}`).val(null)
            // Reinicia el input text(Observaciones)
            $(`#observaciones-${nombreCarpetaDoc}`).val("")

        })

        //$(`#${nombreCarpetaDoc}-del-btn`).toggleClass("disabled-table-icon table-icon")
        /*
        $(`#${nombreCarpetaDoc}-del-btn`).on('click', function () {
            eliminarDocProvedor(provedorId, codigoDocumento, nombreCarpetaDoc, archivoSubido)
        })
        */
    })

    // -- Solucion bug al dar click en el boton de 'Cancelar' --
    var fileElement = event.target,
        files = fileElement.files
    if (fileElement.value == "") { // solamente si el valor estuviera vacio(dio click en cancelar) restaura el valor
        clone[fileElement.id].insertBefore(fileElement);
        $(fileElement).remove()
    }

}


// Metodo que clonara el archivo de algun input file para recuperarlo en caso de que el usuario
// de click en el boton 'Cancelar' al abrir el dialogo de seleccion de archivo
//inputClicked()
function inputClicked(event) {
    var fileElement = event.target
    if (fileElement.value != "") {
        console.log("Clone( #" + fileElement.id + " ) : " + fileElement.value.split("\\").pop())
        clone[fileElement.id] = $(fileElement).clone() // Clona el valor del input
    }
}

// Funcion que se invocara cuando cambie el checkbox de 'No aplica'
function onNoAplicaChange(
    event,
    clienteId,
    codigoTipoDocumento,
    nombreCarpetaDoc,
    cargado,
    noAplica
) {
    // Desactiva el tipo de documento
    if (event.target.checked == true) {
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', true)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', true)
        $(`#${nombreCarpetaDoc}-input`).attr('disabled', "disabled")
        //$(`#${nombreCarpetaDoc}-check`).css('display', 'none')
        //alert(`#${nombreCarpetaDoc}-del-btn`)
        $(`#${nombreCarpetaDoc}-del-btn`).attr('disabled', "disabled")
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("onclick")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
    } else {
        // Activa el tipo de documento
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', false)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', false)
        $(`#${nombreCarpetaDoc}-input`).prop('disabled', false)
        // Si en el registro de documento hay un archivo cargado actualmente
        // el documento originalmente no tenia activada la opcion de 'No aplica'
        // no elimino el archivo recientemente
        let deletedRecent = $(`#file-del-${nombreCarpetaDoc}`).val() // 'T' o 'F'
        if (cargado == "True" && noAplica == "False" && deletedRecent == "F") {
            $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("disabled")
            $(`#${nombreCarpetaDoc}-del-btn`).on('click', () => {
                eliminarDocCliente(clienteId, codigoTipoDocumento, nombreCarpetaDoc)
            })
        }
    }
}